/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.haml.internal.text.rules;

import com.aptana.editor.common.TextUtils;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HAMLEscapeRule
implements IPredicateRule {
    private static final char ESCAPE = '\\';
    private final IToken successToken;

    public HAMLEscapeRule(IToken token) {
        this.successToken = token;
    }

    public IToken getSuccessToken() {
        return this.successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int c;
        if (!resume && (c = scanner.read()) != -1) {
            if (92 == c) {
                c = scanner.read();
                if (c != -1 && !HAMLEscapeRule.isNewLine(scanner, c)) {
                    return this.successToken;
                }
                scanner.unread();
            }
            scanner.unread();
        }
        return Token.UNDEFINED;
    }

    private static boolean isNewLine(ICharacterScanner characterScanner, int c) {
        char[][] newLineSequences;
        char[][] cArray = newLineSequences = TextUtils.rsort((char[][])characterScanner.getLegalLineDelimiters());
        int n = newLineSequences.length;
        int n2 = 0;
        while (n2 < n) {
            char[] sequence = cArray[n2];
            if (c == sequence[0]) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

